/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;

public class Picture {
    private final int ColAPPROX = 10;
    private CircuitComponent puppetOwner;
    private String url;
    private BufferedImage image;
    private int width;
    private int height;
    private Coordinates coordinates;
    private String description;
    private boolean allowedToDraw;
    private float naturalScale;

    public Picture(String string, float f, String string2, String string3, CircuitComponent circuitComponent) {
        this.url = string;
        try {
            File file = new File(string);
            this.image = file.isFile() ? ImageIO.read(file) : ImageIO.read(new URL(string));
            this.width = this.image.getWidth(null);
            this.height = this.image.getHeight(null);
            this.coordinates = new Coordinates(0, 0);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not open file: " + string);
        }
        if (this.image == null) {
            throw new RuntimeException("Invalid image file: " + string);
        }
        this.puppetOwner = circuitComponent;
        this.description = string2;
        this.allowedToDraw = true;
        this.naturalScale = f;
    }

    public Picture(String string, float f, String string2, String string3) {
        this(string, f, string2, string3, null);
    }

    public Picture(String string, float f, String string2) {
        this(string, f, string2, null, null);
    }

    public Picture(String string, float f) {
        this(string, f, "", null, null);
    }

    public Picture(String string) {
        this(string, 1.0f, "", null);
    }

    public Picture clone(String string) {
        return new Picture(this.url, this.naturalScale, string, "", this.puppetOwner);
    }

    public Picture clone() {
        return this.clone("clone");
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public int getX() {
        return this.coordinates.getX();
    }

    public void setX(int n) {
        this.coordinates.setX(n);
    }

    public int getY() {
        return this.coordinates.getY();
    }

    public void setY(int n) {
        this.coordinates.setY(n);
    }

    public int getHeight() {
        return (int)((float)this.height * this.naturalScale);
    }

    public int getWidth() {
        return (int)((float)this.width * this.naturalScale);
    }

    public CircuitComponent getPuppetOwner() {
        return this.puppetOwner;
    }

    public boolean getAllowedToDraw() {
        return this.allowedToDraw;
    }

    public void setAllowedToDraw(boolean bl) {
        this.allowedToDraw = bl;
    }

    public String getDescription() {
        return this.description;
    }

    Color getColor(int n, int n2) {
        if (n > this.width - 10 || n2 > this.height - 10) {
            return null;
        }
        return new Color(this.image.getRGB(n, n2));
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

