/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.Iterator;

public class LogicCanvas
extends Canvas {
    private GUIHandler father;
    private BufferedImage constructing;
    private int width;
    private int height;
    private boolean lineBuilding;
    private int x1;
    private int x2;
    private int y1;
    private int y2;

    public LogicCanvas(GUIHandler gUIHandler) {
        this.father = gUIHandler;
        this.width = (int)GUIHandlerGraphics.DEFAULT_DIMENSION.getWidth();
        this.height = (int)GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight();
        this.lineBuilding = false;
        this.y2 = 0;
        this.y1 = 0;
        this.x2 = 0;
        this.x1 = 0;
        this.addKeyListener(new KeyboardListener(gUIHandler));
        this.addMouseMotionListener(new MotionListener(gUIHandler));
        this.addMouseListener(new InputListener(gUIHandler));
        this.addMouseWheelListener(new WheelListener(gUIHandler));
        this.setSize(new Dimension(this.width, this.height));
        this.setBackground(new Color(255, 255, 255));
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public void update(Graphics graphics) {
        Iterator iterator;
        Object object;
        Object object22;
        this.constructing = new BufferedImage(this.width, this.height, 2);
        this.construct(this.father.getGrid());
        if (this.lineBuilding) {
            this.constructLine(this.x1, this.y1, this.x2, this.y2);
        }
        ArrayListCableLineGraphics arrayListCableLineGraphics = this.father.getCablesGraphics();
        for (Object object22 : arrayListCableLineGraphics) {
            object = ((CableLineGraphics)object22).getPictures();
            iterator = ((ArrayListPicture)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.construct((Picture)e);
            }
        }
        DLListCC dLListCC = this.father.getPlacedComponents();
        object22 = dLListCC.iterator();
        while (object22.hasNext()) {
            object = object22.next();
            if (!((DLNodeCC)object).getElement().getCanDraw()) continue;
            this.construct(((DLNodeCC)object).getElement().getPicture().getImage(), (int)((float)(((DLNodeCC)object).getElement().getCoordinates().getX() - this.father.getGridHorizontalThreshold()) * 40.0f), (int)((float)(((DLNodeCC)object).getElement().getCoordinates().getY() - this.father.getGridVerticalThreshold()) * 22.5f), ((DLNodeCC)object).getElement().getPicture().getWidth(), ((DLNodeCC)object).getElement().getPicture().getHeight());
        }
        object22 = this.father.getThingsToDraw();
        object = ((ArrayListPicture)object22).iterator();
        while (object.hasNext()) {
            iterator = object.next();
            if (iterator == null || !((Picture)((Object)iterator)).getAllowedToDraw()) continue;
            this.construct((Picture)((Object)iterator));
        }
        if (this.father.getWindowXScale() == 1.0f && this.father.getWindowYScale() == 1.0f) {
            ((Graphics2D)graphics).drawImage(this.constructing, 0, 0, (int)((float)this.width * this.father.getWindowXScale()), (int)((float)this.height * this.father.getWindowYScale()), null);
        } else {
            ((Graphics2D)graphics).drawImage(this.constructing, 0, 0, (int)((float)this.width * this.father.getWindowXScale() - 14.0f), (int)((float)this.height * this.father.getWindowYScale() - 38.0f), null);
        }
        this.lineBuilding = false;
    }

    public synchronized void update() {
        this.update(this.getGraphics());
    }

    public void construct(Picture picture) {
        this.construct(picture.getImage(), picture.getX(), picture.getY(), picture.getWidth(), picture.getHeight());
    }

    public void construct(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        this.constructing.createGraphics().drawImage(bufferedImage, n, n2, n3, n4, null);
    }

    public void constructLine(int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = this.constructing.createGraphics();
        graphics2D.setColor(new Color(24, 91, 26));
        graphics2D.drawLine(n, n2, n3, n4);
        graphics2D.setColor(Color.WHITE);
    }

    public void constructLineLater(int n, int n2, int n3, int n4) {
        this.lineBuilding = true;
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
    }

    private class InputListener
    implements MouseListener {
        GUIHandler father;

        InputListener(GUIHandler gUIHandler) {
            this.father = gUIHandler;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.father.mouseClicked(mouseEvent.getX(), mouseEvent.getY());
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.father.mousePressed(mouseEvent.getX(), mouseEvent.getY());
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.father.mouseReleased(mouseEvent.getX(), mouseEvent.getY());
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }
    }

    private class KeyboardListener
    implements KeyListener {
        GUIHandler father;

        KeyboardListener(GUIHandler gUIHandler) {
            this.father = gUIHandler;
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.father.keyPressed(keyEvent.getKeyCode());
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private class MotionListener
    implements MouseMotionListener {
        GUIHandler father;

        MotionListener(GUIHandler gUIHandler) {
            this.father = gUIHandler;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.father.mouseMoved(mouseEvent.getX(), mouseEvent.getY());
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.father.mouseDragged(mouseEvent.getX(), mouseEvent.getY());
            this.father.getMouse().setLastX(mouseEvent.getX());
            this.father.getMouse().setLastY(mouseEvent.getY());
        }
    }

    private class WheelListener
    implements MouseWheelListener {
        GUIHandler father;

        WheelListener(GUIHandler gUIHandler) {
            this.father = gUIHandler;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.father.mouseWheelMoved(mouseWheelEvent.getWheelRotation());
        }
    }
}

