/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GUIHandler
extends JFrame {
    private LogicCanvas son;
    private Updater updater;
    private GraphicUpdater graphicUpdater;
    private DLListCC placedComponents;
    private ArrayListPicture thingsToDraw;
    private ArrayListCableLine cables;
    private ArrayListCableLineGraphics cablesGraphics;
    private int cableColor;
    private Mouse mouse;
    private int resetDragX;
    private int resetDragY;
    private CircuitComponent currentlySelected;
    private Picture dragging;
    private CircuitComponent ccDragging;
    private boolean onABridge;
    private IOBridge tempBridge;
    private IOBridge ccLinking;
    private int actualToolbarThreshold = 0;
    private float windowXScale;
    private float windowYScale;
    private boolean[][] gridBusyPositions;
    private Coordinates lastBusyCoordinates;
    private boolean openedControls;
    private int actualGridHorizontalThreshold;
    private int actualGridVerticalThreshold;

    public GUIHandler(boolean bl, float f, float f2) {
        this.windowXScale = f;
        this.windowYScale = f2;
        this.initStartingAssets(bl);
        this.showStartingAssets();
        Thread thread = new Thread(this.updater);
        thread.start();
        Thread thread2 = new Thread(this.graphicUpdater);
        thread2.start();
        this.resizecatch();
    }

    private void initStartingAssets(boolean bl) {
        int n;
        this.setTitle("Logic Gates Simulator - di Catalano Danilo, Gelardi Gabriele, Quattrocchi Marilyn e Trenta Francesca");
        this.setSize((int)(GUIHandlerGraphics.DEFAULT_DIMENSION.getWidth() * (double)this.windowXScale) + 14, (int)(GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight() * (double)this.windowYScale) + 38);
        this.setDefaultCloseOperation(3);
        this.son = new LogicCanvas(this);
        this.updater = new Updater(this);
        this.graphicUpdater = new GraphicUpdater(this.son);
        this.placedComponents = new DLListCC();
        this.thingsToDraw = new ArrayListPicture();
        this.cables = new ArrayListCableLine();
        this.cablesGraphics = new ArrayListCableLineGraphics();
        this.cableColor = 0;
        this.mouse = new Mouse();
        this.dragging = null;
        this.ccDragging = null;
        this.tempBridge = null;
        this.ccLinking = null;
        this.gridBusyPositions = new boolean[128][128];
        this.lastBusyCoordinates = new Coordinates(-1, -1);
        this.openedControls = true;
        this.actualGridVerticalThreshold = 0;
        this.actualGridVerticalThreshold = 0;
        this.currentlySelected = null;
        for (int i = 0; i < 128; ++i) {
            for (n = 0; n < 128; ++n) {
                this.gridBusyPositions[n][i] = false;
            }
        }
        Picture picture = GUIHandlerGraphics.TOOLBAR;
        picture.setX(0);
        picture.setY(0);
        this.thingsToDraw.addLast(picture);
        picture = AND.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_AND_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_AND_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = OR.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_OR_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_OR_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = NOT.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_NOT_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_NOT_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = NAND.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_NAND_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_NAND_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = NOR.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_NOR_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_NOR_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = XOR.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_XOR_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_XOR_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = XNOR.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_XNOR_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_XNOR_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = RELAY.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_RELAY_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_RELAY_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = LEDSCREEN.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_LEDSCREEN_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_LEDSCREEN_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = SWITCH.puppet.getPicture_0();
        picture.setX(GUIHandlerGraphics.T_START_SWITCH_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_SWITCH_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = BUTTON.puppet.getPicture();
        picture.setX(GUIHandlerGraphics.T_START_BUTTON_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_BUTTON_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = LIGHT.puppet.getPicture_0();
        picture.setX(GUIHandlerGraphics.T_START_LIGHT_COORDINATES.getX());
        picture.setY(GUIHandlerGraphics.T_START_LIGHT_COORDINATES.getY());
        this.thingsToDraw.addLast(picture);
        picture = GUIHandlerGraphics.TOOLBAR_40;
        picture.setX(0);
        picture.setY(0);
        this.thingsToDraw.addLast(picture);
        for (n = 0; n < CircuitComponentGraphics.HIGHLIGHTS.length; ++n) {
            picture = CircuitComponentGraphics.HIGHLIGHTS[n];
            picture.setX(0);
            picture.setY(0);
            picture.setAllowedToDraw(false);
            this.thingsToDraw.addLast(picture);
        }
        for (n = 0; n < CircuitComponentGraphics.COMPLETE_FRAMES.length; ++n) {
            picture = CircuitComponentGraphics.COMPLETE_FRAMES[n];
            picture.setX(0);
            picture.setY(0);
            picture.setAllowedToDraw(false);
            this.thingsToDraw.addLast(picture);
        }
        for (n = 0; n < CircuitComponentGraphics.MOVEMENT_FRAMES.length; ++n) {
            picture = CircuitComponentGraphics.MOVEMENT_FRAMES[n];
            picture.setX(0);
            picture.setY(0);
            picture.setAllowedToDraw(false);
            this.thingsToDraw.addLast(picture);
        }
        picture = GUIHandlerGraphics.IOLEFT;
        picture.setX(0);
        picture.setY(0);
        picture.setAllowedToDraw(false);
        this.thingsToDraw.addLast(picture);
        picture = GUIHandlerGraphics.IORIGHT;
        picture.setX(0);
        picture.setY(0);
        picture.setAllowedToDraw(false);
        this.thingsToDraw.addLast(picture);
        picture = GUIHandlerGraphics.CONTROLS;
        picture.setX((int)GUIHandlerGraphics.DEFAULT_DIMENSION.getWidth() - picture.getWidth());
        picture.setY((int)GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight() - picture.getHeight());
        this.thingsToDraw.addLast(picture);
        picture = GUIHandlerGraphics.CONTROLS_MINIMIZED;
        picture.setX((int)GUIHandlerGraphics.DEFAULT_DIMENSION.getWidth() - picture.getWidth());
        picture.setY((int)GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight() - picture.getHeight());
        picture.setAllowedToDraw(false);
        this.thingsToDraw.addLast(picture);
        if (bl) {
            try {
                File file = new File("saves/DefaultExample.lgs");
                if (file.exists()) {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    this.placedComponents = (DLListCC)objectInputStream.readObject();
                    this.cables = (ArrayListCableLine)objectInputStream.readObject();
                    this.cablesGraphics = new ArrayListCableLineGraphics();
                    for (Object e : this.cables) {
                        ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                        CableLineGraphics cableLineGraphics = new CableLineGraphics();
                        ((CableLine)e).createGraphics(cableLineGraphics.getPictures());
                        this.cablesGraphics.addLast(cableLineGraphics);
                    }
                    this.gridBusyPositions = (boolean[][])objectInputStream.readObject();
                } else {
                    JOptionPane.showMessageDialog(this, "Loading default example failed, continuing with an empty Canvas", "Loading...", 0);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Loading default example failed, continuing with an empty Canvas", "Loading...", 0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                JOptionPane.showMessageDialog(this, "Loading default example failed, continuing with an empty Canvas", "Loading...", 0);
            }
        }
    }

    private void riseToolbarItems() {
        this.moveToolbarItems(-20);
    }

    private void fallToolbarItems() {
        this.moveToolbarItems(20);
    }

    private void moveToolbarItems(int n) {
        block4: {
            block3: {
                if (n <= 0) break block3;
                if (this.thingsToDraw.get(1).getY() >= 10) break block4;
                for (int i = 1; i <= 12; ++i) {
                    this.thingsToDraw.get(i).setY(this.thingsToDraw.get(i).getY() + n);
                    this.actualToolbarThreshold += n;
                }
                break block4;
            }
            if (!(GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight() - (double)(this.thingsToDraw.get(12).getY() + this.thingsToDraw.get(12).getHeight()) >= 10.0)) {
                for (int i = 1; i <= 12; ++i) {
                    this.thingsToDraw.get(i).setY(this.thingsToDraw.get(i).getY() + n);
                    this.actualToolbarThreshold += n;
                }
            }
        }
    }

    private Picture searchtempBridgeToolbarItem(int n, int n2) {
        for (int i = 1; i <= 12; ++i) {
            if (n < this.thingsToDraw.get(i).getX() || n > this.thingsToDraw.get(i).getX() + this.thingsToDraw.get(i).getWidth() || n2 < this.thingsToDraw.get(i).getY() || n2 > this.thingsToDraw.get(i).getY() + this.thingsToDraw.get(i).getHeight()) continue;
            return this.thingsToDraw.get(i);
        }
        return null;
    }

    private void showStartingAssets() {
        this.add((Component)this.son, "Center");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void updateCircuit() {
        if (this.placedComponents.getSize() > 0) {
            DLListCC dLListCC = new DLListCC();
            for (Object e : this.placedComponents) {
                ((DLNodeCC)e).getElement().setVisited(false);
                if (!(((DLNodeCC)e).getElement() instanceof INPUT)) continue;
                dLListCC.addLast(((DLNodeCC)e).getElement());
            }
            if (dLListCC.getSize() > 0) {
                for (Object e : dLListCC) {
                    if (!((DLNodeCC)e).getElement().getVisited()) {
                        ((DLNodeCC)e).getElement().calculateOutputs();
                        int n = ((DLNodeCC)e).getElement().getNOutputs();
                        for (int i = 0; i < n; ++i) {
                            if (((DLNodeCC)e).getElement().getOutputBridgeAt(i).getLink() == null) continue;
                            dLListCC.addLast(((DLNodeCC)e).getElement().getOutputBridgeAt(i).getLink().getOwner());
                        }
                        ((DLNodeCC)e).getElement().setVisited(true);
                    }
                    dLListCC.remove((DLNodeCC)e);
                }
            }
        }
    }

    public void decrementVerticalThreshold() {
        if (this.actualGridVerticalThreshold > 0) {
            --this.actualGridVerticalThreshold;
            this.cleanOverlayVariables();
            int n = 0;
            for (Object e : this.cables) {
                ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                this.cablesGraphics.get(n).cleanGraphics();
                ((CableLine)e).createGraphics(this.cablesGraphics.get(n).getPictures());
                ++n;
            }
        }
    }

    public void incrementVerticalThreshold() {
        if (32 + this.actualGridVerticalThreshold < 128) {
            ++this.actualGridVerticalThreshold;
            this.cleanOverlayVariables();
            int n = 0;
            for (Object e : this.cables) {
                ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                this.cablesGraphics.get(n).cleanGraphics();
                ((CableLine)e).createGraphics(this.cablesGraphics.get(n).getPictures());
                ++n;
            }
        }
    }

    public void decrementHorizontalThreshold() {
        if (this.actualGridHorizontalThreshold > 0) {
            --this.actualGridHorizontalThreshold;
            this.cleanOverlayVariables();
            int n = 0;
            for (Object e : this.cables) {
                ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                this.cablesGraphics.get(n).cleanGraphics();
                ((CableLine)e).createGraphics(this.cablesGraphics.get(n).getPictures());
                ++n;
            }
        }
    }

    public void incrementHorizontalThreshold() {
        if (32 + this.actualGridHorizontalThreshold < 128) {
            ++this.actualGridHorizontalThreshold;
            this.cleanOverlayVariables();
            int n = 0;
            for (Object e : this.cables) {
                ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                this.cablesGraphics.get(n).cleanGraphics();
                ((CableLine)e).createGraphics(this.cablesGraphics.get(n).getPictures());
                ++n;
            }
        }
    }

    public void keyPressed(int n) {
        if (n == 38) {
            this.decrementVerticalThreshold();
        } else if (n == 37) {
            this.decrementHorizontalThreshold();
        } else if (n == 39) {
            this.incrementHorizontalThreshold();
        } else if (n == 40) {
            this.incrementVerticalThreshold();
        }
    }

    public void mouseClicked(int n, int n2) {
        if (this.dragging == null && this.currentlySelected != null && this.currentlySelected instanceof INPUT && ((INPUT)this.currentlySelected).isToggle()) {
            ((INPUT)this.currentlySelected).switchState();
        }
    }

    public void mouseDragged(int n, int n2) {
        if (this.ccLinking == null && this.rescaleTo1X(n) <= 240) {
            Picture picture = this.thingsToDraw.get(this.thingsToDraw.searchByDescription("toolbartransparency"));
            if (picture != null) {
                picture.setAllowedToDraw(false);
                if (this.dragging == null) {
                    this.dragging = this.searchtempBridgeToolbarItem(this.rescaleTo1X(n), this.rescaleTo1Y(n2));
                    if (this.dragging != null) {
                        this.resetDragX = this.dragging.getX();
                        this.resetDragY = this.dragging.getY();
                    }
                } else {
                    int n3 = this.rescaleTo1X(n) - this.rescaleTo1X(this.mouse.getLastX());
                    int n4 = this.rescaleTo1Y(n2) - this.rescaleTo1Y(this.mouse.getLastY());
                    this.dragging.setX(this.dragging.getX() + n3);
                    this.dragging.setY(this.dragging.getY() + n4);
                    if (this.ccDragging != null) {
                        Picture picture2 = CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()];
                        picture2.setX(this.dragging.getX() - CircuitComponentGraphics.FRAMES_BORDERS[this.ccDragging.getBlockType()]);
                        picture2.setY(this.dragging.getY() - CircuitComponentGraphics.FRAMES_BORDERS[this.ccDragging.getBlockType()]);
                    }
                    for (int i = 0; i < CircuitComponentGraphics.HIGHLIGHTS.length; ++i) {
                        CircuitComponentGraphics.HIGHLIGHTS[i].setAllowedToDraw(false);
                    }
                }
            }
        } else if (this.ccLinking != null) {
            this.son.constructLineLater(this.ccLinking.getCoordinates().getX() - (int)((float)this.actualGridHorizontalThreshold * 40.0f) + (int)(this.ccLinking.getDimension().getWidth() / 2.0), this.ccLinking.getCoordinates().getY() - (int)((float)this.actualGridVerticalThreshold * 22.5f) + (int)(this.ccLinking.getDimension().getHeight() / 2.0), this.rescaleTo1X(n), this.rescaleTo1Y(n2));
            if (this.ccLinking.isInput()) {
                GUIHandlerGraphics.IORIGHT.setAllowedToDraw(false);
            } else {
                GUIHandlerGraphics.IOLEFT.setAllowedToDraw(false);
            }
            this.tempBridge = null;
            for (Object e : this.placedComponents) {
                this.tempBridge = ((DLNodeCC)e).getElement().checkTouched(this.rescaleTo1X(n) + (int)((float)this.actualGridHorizontalThreshold * 40.0f), this.rescaleTo1Y(n2) + (int)((float)this.actualGridVerticalThreshold * 22.5f));
                if (this.tempBridge == null) continue;
                if (this.ccLinking.isInput() && !this.tempBridge.isInput()) {
                    GUIHandlerGraphics.IORIGHT.setX(this.tempBridge.getCoordinates().getX() - (int)((float)this.actualGridHorizontalThreshold * 40.0f));
                    GUIHandlerGraphics.IORIGHT.setY(this.tempBridge.getCoordinates().getY() - (int)((float)this.actualGridVerticalThreshold * 22.5f));
                    GUIHandlerGraphics.IORIGHT.setAllowedToDraw(true);
                } else if (!this.ccLinking.isInput() && this.tempBridge.isInput()) {
                    GUIHandlerGraphics.IOLEFT.setX(this.tempBridge.getCoordinates().getX() - (int)((float)this.actualGridHorizontalThreshold * 40.0f));
                    GUIHandlerGraphics.IOLEFT.setY(this.tempBridge.getCoordinates().getY() - (int)((float)this.actualGridVerticalThreshold * 22.5f));
                    GUIHandlerGraphics.IOLEFT.setAllowedToDraw(true);
                }
                this.onABridge = true;
                break;
            }
        } else {
            Picture picture = this.thingsToDraw.get(this.thingsToDraw.searchByDescription("toolbartransparency"));
            if (picture != null) {
                picture.setAllowedToDraw(true);
            }
            if (this.dragging != null) {
                int n5 = this.rescaleTo1X(n) - this.rescaleTo1X(this.mouse.getLastX());
                int n6 = this.rescaleTo1Y(n2) - this.rescaleTo1Y(this.mouse.getLastY());
                this.dragging.setX(this.dragging.getX() + n5);
                this.dragging.setY(this.dragging.getY() + n6);
                int n7 = this.getBlockTypeFromPicture(this.dragging);
                if (this.ccDragging != null) {
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setX(CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].getX() + n5);
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setY(CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].getY() + n6);
                }
                Picture picture3 = CircuitComponentGraphics.HIGHLIGHTS[n7];
                int n8 = this.dragging.getX() + 20;
                int n9 = this.dragging.getY() + 11;
                int n10 = n8 / 40 + this.actualGridHorizontalThreshold;
                int n11 = n9 / 22 + this.actualGridVerticalThreshold;
                if (n10 < 7 || (double)(n10 - 1) + CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n7].getWidth() >= 127.0 || n11 < 1 || (double)n11 + CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n7].getHeight() >= 128.0) {
                    picture3.setAllowedToDraw(false);
                } else if (this.isGridFree(n10, n11, n7)) {
                    picture3.setX((int)(40.0f * (float)(n10 - this.actualGridHorizontalThreshold)));
                    picture3.setY((int)(22.5f * (float)(n11 - this.actualGridVerticalThreshold)));
                    picture3.setAllowedToDraw(true);
                    this.lastBusyCoordinates.setX(n10);
                    this.lastBusyCoordinates.setY(n11);
                } else {
                    picture3.setAllowedToDraw(false);
                }
            }
        }
    }

    public void cleanOverlayVariables() {
        int n;
        GUIHandlerGraphics.IOLEFT.setAllowedToDraw(false);
        GUIHandlerGraphics.IORIGHT.setAllowedToDraw(false);
        for (n = 0; n < CircuitComponentGraphics.COMPLETE_FRAMES.length; ++n) {
            CircuitComponentGraphics.COMPLETE_FRAMES[n].setAllowedToDraw(false);
        }
        for (n = 0; n < CircuitComponentGraphics.MOVEMENT_FRAMES.length; ++n) {
            CircuitComponentGraphics.MOVEMENT_FRAMES[n].setAllowedToDraw(false);
        }
        this.currentlySelected = null;
        this.onABridge = false;
    }

    public void mouseMoved(int n, int n2) {
        this.cleanOverlayVariables();
        if (this.rescaleTo1X(n) <= 240) {
            Picture picture = this.thingsToDraw.get(this.thingsToDraw.searchByDescription("toolbartransparency"));
            if (picture != null) {
                picture.setAllowedToDraw(false);
            }
        } else {
            Picture picture = this.thingsToDraw.get(this.thingsToDraw.searchByDescription("toolbartransparency"));
            if (picture != null) {
                picture.setAllowedToDraw(true);
            }
            this.tempBridge = null;
            for (Object e : this.placedComponents) {
                this.tempBridge = ((DLNodeCC)e).getElement().checkTouched(this.rescaleTo1X(n) + (int)((float)this.actualGridHorizontalThreshold * 40.0f), this.rescaleTo1Y(n2) + (int)((float)this.actualGridVerticalThreshold * 22.5f));
                if (this.tempBridge == null) continue;
                if (this.tempBridge.isInput()) {
                    GUIHandlerGraphics.IOLEFT.setX(this.tempBridge.getCoordinates().getX() - (int)((float)this.actualGridHorizontalThreshold * 40.0f));
                    GUIHandlerGraphics.IOLEFT.setY(this.tempBridge.getCoordinates().getY() - (int)((float)this.actualGridVerticalThreshold * 22.5f));
                    GUIHandlerGraphics.IOLEFT.setAllowedToDraw(true);
                } else {
                    GUIHandlerGraphics.IORIGHT.setX(this.tempBridge.getCoordinates().getX() - (int)((float)this.actualGridHorizontalThreshold * 40.0f));
                    GUIHandlerGraphics.IORIGHT.setY(this.tempBridge.getCoordinates().getY() - (int)((float)this.actualGridVerticalThreshold * 22.5f));
                    GUIHandlerGraphics.IORIGHT.setAllowedToDraw(true);
                }
                this.onABridge = true;
                break;
            }
            if (this.tempBridge == null) {
                int n3 = (int)((float)this.rescaleTo1X(n) / 40.0f) + this.actualGridHorizontalThreshold;
                int n4 = (int)((float)this.rescaleTo1Y(n2) / 22.5f) + this.actualGridVerticalThreshold;
                if (n3 < 128 && n4 < 128) {
                    if (this.gridBusyPositions[n3][n4]) {
                        while (this.gridBusyPositions[n3][n4]) {
                            --n3;
                        }
                        ++n3;
                        while (n4 >= 0 && this.gridBusyPositions[n3][n4]) {
                            --n4;
                        }
                        ++n4;
                    }
                    this.lastBusyCoordinates.setX(n3);
                    this.lastBusyCoordinates.setY(n4);
                    CircuitComponent circuitComponent = this.placedComponents.searchElementByCoordinates(new Coordinates(n3, n4));
                    if (circuitComponent != null) {
                        Picture picture2 = CircuitComponentGraphics.COMPLETE_FRAMES[circuitComponent.getBlockType()];
                        picture2.setX((int)((float)(n3 - this.actualGridHorizontalThreshold) * 40.0f - (float)CircuitComponentGraphics.FRAMES_BORDERS[circuitComponent.getBlockType()]));
                        picture2.setY((int)((float)(n4 - this.actualGridVerticalThreshold) * 22.5f - (float)CircuitComponentGraphics.FRAMES_BORDERS[circuitComponent.getBlockType()]));
                        this.currentlySelected = circuitComponent;
                        picture2.setAllowedToDraw(true);
                    }
                }
            }
        }
    }

    public void mousePressed(int n, int n2) {
        block52: {
            if (this.rescaleTo1X(n) >= GUIHandlerGraphics.T_BUTTON_UP_COORDINATES.getX() && this.rescaleTo1X(n) <= GUIHandlerGraphics.T_BUTTON_UP_COORDINATES.getX() + (int)GUIHandlerGraphics.T_BUTTON_DIMENSION.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.T_BUTTON_UP_COORDINATES.getY() && this.rescaleTo1Y(n2) <= GUIHandlerGraphics.T_BUTTON_UP_COORDINATES.getY() + (int)GUIHandlerGraphics.T_BUTTON_DIMENSION.getHeight()) {
                this.fallToolbarItems();
            } else if (this.rescaleTo1X(n) >= GUIHandlerGraphics.T_BUTTON_DOWN_COORDINATES.getX() && this.rescaleTo1X(n) <= GUIHandlerGraphics.T_BUTTON_DOWN_COORDINATES.getX() + (int)GUIHandlerGraphics.T_BUTTON_DIMENSION.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.T_BUTTON_DOWN_COORDINATES.getY() && this.rescaleTo1Y(n2) <= GUIHandlerGraphics.T_BUTTON_DOWN_COORDINATES.getY() + (int)GUIHandlerGraphics.T_BUTTON_DIMENSION.getHeight()) {
                this.riseToolbarItems();
            } else if (!this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS_MINIMIZED.getX() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS_MINIMIZED.getY()) {
                this.openedControls = true;
                GUIHandlerGraphics.CONTROLS_MINIMIZED.setAllowedToDraw(false);
                GUIHandlerGraphics.CONTROLS.setAllowedToDraw(true);
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_CLOSE.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_CLOSE.getX()) + GUIHandlerGraphics.C_BUTTON_CLOSE_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_CLOSE.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_CLOSE.getY()) + GUIHandlerGraphics.C_BUTTON_CLOSE_DIM.getHeight()) {
                this.openedControls = false;
                GUIHandlerGraphics.CONTROLS.setAllowedToDraw(false);
                GUIHandlerGraphics.CONTROLS_MINIMIZED.setAllowedToDraw(true);
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_UP.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_UP.getX()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_UP.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_UP.getY()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getHeight()) {
                this.decrementVerticalThreshold();
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_LEFT.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_LEFT.getX()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_LEFT.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_LEFT.getY()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getHeight()) {
                this.decrementHorizontalThreshold();
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_RIGHT.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_RIGHT.getX()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_RIGHT.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_RIGHT.getY()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getHeight()) {
                this.incrementHorizontalThreshold();
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_DOWN.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_DOWN.getX()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_DOWN.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_DOWN.getY()) + GUIHandlerGraphics.C_BUTTON_DIRECTION_DIM.getHeight()) {
                this.incrementVerticalThreshold();
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_DELETE.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_DELETE.getX()) + GUIHandlerGraphics.C_BUTTON_DELETE_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_DELETE.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_DELETE.getY()) + GUIHandlerGraphics.C_BUTTON_DELETE_DIM.getHeight()) {
                this.placedComponents = new DLListCC();
                this.cables = new ArrayListCableLine();
                this.cablesGraphics = new ArrayListCableLineGraphics();
                for (int i = 0; i < 128; ++i) {
                    for (int j = 0; j < 128; ++j) {
                        this.gridBusyPositions[j][i] = false;
                    }
                }
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_SAVE.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_SAVE.getX()) + GUIHandlerGraphics.C_BUTTON_SAVE_LOAD_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_SAVE.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_SAVE.getY()) + GUIHandlerGraphics.C_BUTTON_SAVE_LOAD_DIM.getHeight()) {
                try {
                    String string = JOptionPane.showInputDialog("Insert save-file name (must be strictly alpha-numeric):");
                    if (string != null && !string.equals("")) {
                        boolean bl = true;
                        for (int i = 0; i < string.length(); ++i) {
                            char c = string.charAt(i);
                            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                            bl = false;
                        }
                        if (bl) {
                            File file = new File("saves/" + string + ".lgs");
                            if (!file.exists() || JOptionPane.showConfirmDialog(this, "File already exists, do you want to overwrite?", "Overwrite?", 0) == 0) {
                                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                                objectOutputStream.writeObject(this.placedComponents);
                                objectOutputStream.writeObject(this.cables);
                                objectOutputStream.writeObject(this.gridBusyPositions);
                                JOptionPane.showMessageDialog(this, "File successfully saved.", "Saving...", 1);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Filename format invalid.", "Saving...", 0);
                        }
                        break block52;
                    }
                    JOptionPane.showMessageDialog(this, "Filename format invalid.", "Saving...", 0);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Save failed.", "Saving...", 0);
                }
            } else if (this.openedControls && this.rescaleTo1X(n) >= GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_LOAD.getX() && (double)this.rescaleTo1X(n) <= (double)(GUIHandlerGraphics.CONTROLS.getX() + GUIHandlerGraphics.C_BUTTON_LOAD.getX()) + GUIHandlerGraphics.C_BUTTON_SAVE_LOAD_DIM.getWidth() && this.rescaleTo1Y(n2) >= GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_LOAD.getY() && (double)this.rescaleTo1Y(n2) <= (double)(GUIHandlerGraphics.CONTROLS.getY() + GUIHandlerGraphics.C_BUTTON_LOAD.getY()) + GUIHandlerGraphics.C_BUTTON_SAVE_LOAD_DIM.getHeight()) {
                try {
                    String string = JOptionPane.showInputDialog("Insert save-file name (must be strictly alpha-numeric):");
                    if (string != null && !string.equals("")) {
                        boolean bl = true;
                        for (int i = 0; i < string.length(); ++i) {
                            char c = string.charAt(i);
                            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
                            bl = false;
                        }
                        if (bl) {
                            File file = new File("saves/" + string + ".lgs");
                            if (file.exists()) {
                                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                                this.placedComponents = (DLListCC)objectInputStream.readObject();
                                this.cables = (ArrayListCableLine)objectInputStream.readObject();
                                this.cablesGraphics = new ArrayListCableLineGraphics();
                                for (Object e : this.cables) {
                                    ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                                    CableLineGraphics cableLineGraphics = new CableLineGraphics();
                                    ((CableLine)e).createGraphics(cableLineGraphics.getPictures());
                                    this.cablesGraphics.addLast(cableLineGraphics);
                                }
                                this.gridBusyPositions = (boolean[][])objectInputStream.readObject();
                                JOptionPane.showMessageDialog(this, "File successfully loaded.", "Loading...", 1);
                            } else {
                                JOptionPane.showMessageDialog(this, "Load failed.", "Loading...", 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(this, "Filename format invalid.", "Loading...", 0);
                        }
                        break block52;
                    }
                    JOptionPane.showMessageDialog(this, "Filename format invalid.", "Saving...", 0);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(this, "Load failed.", "Loading...", 0);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    JOptionPane.showMessageDialog(this, "Load failed.", "Loading...", 0);
                }
            } else if (this.currentlySelected != null) {
                if (this.rescaleTo1X(n) <= (int)((float)(this.currentlySelected.getCoordinates().getX() - this.actualGridHorizontalThreshold) * 40.0f + 17.0f) && this.rescaleTo1Y(n2) <= (int)((float)(this.currentlySelected.getCoordinates().getY() - this.actualGridVerticalThreshold) * 22.5f + 17.0f)) {
                    this.ccDragging = this.currentlySelected;
                    this.ccDragging.setCanDraw(false);
                    this.freeGrid(this.currentlySelected.getCoordinates().getX(), this.currentlySelected.getCoordinates().getY(), this.ccDragging.getBlockType());
                    this.dragging = this.ccDragging.getPicture().clone();
                    this.dragging.setX((int)(40.0f * (float)(this.currentlySelected.getCoordinates().getX() - this.actualGridHorizontalThreshold)));
                    this.dragging.setY((int)(22.5f * (float)(this.currentlySelected.getCoordinates().getY() - this.actualGridVerticalThreshold)));
                    Picture picture = CircuitComponentGraphics.HIGHLIGHTS[this.ccDragging.getBlockType()];
                    picture.setX(this.dragging.getX());
                    picture.setY(this.dragging.getY());
                    picture.setAllowedToDraw(true);
                    CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].setAllowedToDraw(false);
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setX(CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].getX());
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setY(CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].getY());
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setAllowedToDraw(true);
                    this.thingsToDraw.addAt(this.dragging, 13);
                } else if (this.rescaleTo1X(n) >= (int)((double)((float)(this.currentlySelected.getCoordinates().getX() - this.actualGridHorizontalThreshold) * 40.0f) + (this.currentlySelected.getDimension().getWidth() - 17.0)) && this.rescaleTo1Y(n2) >= (int)((double)((float)(this.currentlySelected.getCoordinates().getY() - this.actualGridVerticalThreshold) * 22.5f) + (this.currentlySelected.getDimension().getHeight() - 17.0))) {
                    int n3;
                    int n4;
                    this.placedComponents.removeByElement(this.currentlySelected);
                    this.freeGrid(this.currentlySelected.getCoordinates().getX(), this.currentlySelected.getCoordinates().getY(), this.currentlySelected.getBlockType());
                    CircuitComponentGraphics.COMPLETE_FRAMES[this.currentlySelected.getBlockType()].setAllowedToDraw(false);
                    for (n4 = 0; n4 < this.currentlySelected.getNInputs(); ++n4) {
                        this.currentlySelected.getInputBridgeAt(n4).resetLink();
                        n3 = this.cables.searchByTerminal(this.currentlySelected.getInputBridgeAt(n4));
                        if (n3 == -1) continue;
                        this.cables.remove(n3);
                        this.cablesGraphics.remove(n3);
                    }
                    for (n4 = 0; n4 < this.currentlySelected.getNOutputs(); ++n4) {
                        this.currentlySelected.getOutputBridgeAt(n4).resetLink();
                        n3 = this.cables.searchByTerminal(this.currentlySelected.getOutputBridgeAt(n4));
                        if (n3 == -1) continue;
                        this.cables.remove(n3);
                        this.cablesGraphics.remove(n3);
                    }
                    this.currentlySelected = null;
                    this.ccDragging = null;
                    if (this.dragging != null) {
                        this.dragging.setX(this.resetDragX);
                        this.dragging.setY(this.resetDragY);
                        this.dragging = null;
                    }
                } else if (this.currentlySelected != null && this.currentlySelected instanceof INPUT && !((INPUT)this.currentlySelected).isToggle()) {
                    ((INPUT)this.currentlySelected).setState(true);
                }
            } else if (this.onABridge) {
                this.ccLinking = this.tempBridge;
            }
        }
    }

    public void mouseReleased(int n, int n2) {
        if (this.ccLinking != null) {
            if (this.tempBridge != null && this.ccLinking.isInput() != this.tempBridge.isInput()) {
                this.ccLinking.setLink(this.tempBridge);
                this.tempBridge.setLink(this.ccLinking);
                if (this.cableColor >= 7) {
                    this.cableColor = 0;
                }
                if (this.ccLinking.isInput()) {
                    int n3 = this.cables.searchByTerminal(this.tempBridge);
                    if (n3 != -1) {
                        if (this.cables.get(n3).getIBridge() != this.ccLinking) {
                            this.cables.remove(n3);
                            this.cablesGraphics.remove(n3);
                            int n4 = this.cables.searchByTerminal(this.ccLinking);
                            if (n4 != -1) {
                                this.cables.remove(n4);
                                this.cablesGraphics.remove(n4);
                            }
                            CableLine cableLine = new CableLine((OutputBridge)this.tempBridge, (InputBridge)this.ccLinking, this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold, this.cableColor++);
                            this.cables.addLast(cableLine);
                            CableLineGraphics cableLineGraphics = new CableLineGraphics();
                            cableLine.createGraphics(cableLineGraphics.getPictures());
                            this.cablesGraphics.addLast(cableLineGraphics);
                        }
                    } else {
                        int n5 = this.cables.searchByTerminal(this.ccLinking);
                        if (n5 != -1) {
                            this.cables.remove(n5);
                            this.cablesGraphics.remove(n5);
                        }
                        CableLine cableLine = new CableLine((OutputBridge)this.tempBridge, (InputBridge)this.ccLinking, this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold, this.cableColor++);
                        this.cables.addLast(cableLine);
                        CableLineGraphics cableLineGraphics = new CableLineGraphics();
                        cableLine.createGraphics(cableLineGraphics.getPictures());
                        this.cablesGraphics.addLast(cableLineGraphics);
                    }
                } else {
                    int n6 = this.cables.searchByTerminal(this.ccLinking);
                    if (n6 != -1) {
                        if (this.cables.get(n6).getIBridge() != this.tempBridge) {
                            this.cables.remove(n6);
                            this.cablesGraphics.remove(n6);
                            int n7 = this.cables.searchByTerminal(this.tempBridge);
                            if (n7 != -1) {
                                this.cables.remove(n7);
                                this.cablesGraphics.remove(n7);
                            }
                            CableLine cableLine = new CableLine((OutputBridge)this.ccLinking, (InputBridge)this.tempBridge, this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold, this.cableColor++);
                            this.cables.addLast(cableLine);
                            CableLineGraphics cableLineGraphics = new CableLineGraphics();
                            cableLine.createGraphics(cableLineGraphics.getPictures());
                            this.cablesGraphics.addLast(cableLineGraphics);
                        }
                    } else {
                        int n8 = this.cables.searchByTerminal(this.tempBridge);
                        if (n8 != -1) {
                            this.cables.remove(n8);
                            this.cablesGraphics.remove(n8);
                        }
                        CableLine cableLine = new CableLine((OutputBridge)this.ccLinking, (InputBridge)this.tempBridge, this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold, this.cableColor++);
                        this.cables.addLast(cableLine);
                        CableLineGraphics cableLineGraphics = new CableLineGraphics();
                        cableLine.createGraphics(cableLineGraphics.getPictures());
                        this.cablesGraphics.addLast(cableLineGraphics);
                    }
                }
            }
            GUIHandlerGraphics.IOLEFT.setAllowedToDraw(false);
            GUIHandlerGraphics.IORIGHT.setAllowedToDraw(false);
            this.onABridge = false;
            this.tempBridge = null;
            this.ccLinking = null;
        } else if (this.dragging != null) {
            int n9;
            for (n9 = 0; n9 < CircuitComponentGraphics.HIGHLIGHTS.length; ++n9) {
                if (!CircuitComponentGraphics.HIGHLIGHTS[n9].getAllowedToDraw()) continue;
                if (this.ccDragging != null) {
                    this.freeGrid(this.ccDragging.getCoordinates().getX(), this.ccDragging.getCoordinates().getY(), this.ccDragging.getBlockType());
                    this.ccDragging.setX(this.lastBusyCoordinates.getX());
                    this.ccDragging.setY(this.lastBusyCoordinates.getY());
                    this.occupyGrid(this.ccDragging.getCoordinates().getX(), this.ccDragging.getCoordinates().getY(), this.ccDragging.getBlockType());
                    CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setAllowedToDraw(false);
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setX((int)((float)(this.lastBusyCoordinates.getX() - this.actualGridHorizontalThreshold) * 40.0f) - CircuitComponentGraphics.FRAMES_BORDERS[n9]);
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setY((int)((float)(this.lastBusyCoordinates.getY() - this.actualGridVerticalThreshold) * 22.5f) - CircuitComponentGraphics.FRAMES_BORDERS[n9]);
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setAllowedToDraw(true);
                    this.ccDragging.setCanDraw(true);
                    this.ccDragging = null;
                } else {
                    CircuitComponent circuitComponent = this.getInstanceFromPicture(this.dragging, this.lastBusyCoordinates.getX(), this.lastBusyCoordinates.getY());
                    this.placedComponents.addFirst(circuitComponent);
                    this.occupyGrid(circuitComponent.getCoordinates().getX(), circuitComponent.getCoordinates().getY(), circuitComponent.getBlockType());
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setX((int)((float)(this.lastBusyCoordinates.getX() - this.actualGridHorizontalThreshold) * 40.0f) - CircuitComponentGraphics.FRAMES_BORDERS[n9]);
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setY((int)((float)(this.lastBusyCoordinates.getY() - this.actualGridVerticalThreshold) * 22.5f) - CircuitComponentGraphics.FRAMES_BORDERS[n9]);
                    CircuitComponentGraphics.COMPLETE_FRAMES[n9].setAllowedToDraw(true);
                }
                n9 = CircuitComponentGraphics.HIGHLIGHTS.length;
            }
            while ((n9 = this.thingsToDraw.searchByDescription("clone")) != -1) {
                this.thingsToDraw.remove(n9);
            }
            this.dragging.setX(this.resetDragX);
            this.dragging.setY(this.resetDragY);
            this.dragging = null;
            if (this.ccDragging != null) {
                this.occupyGrid(this.ccDragging.getCoordinates().getX(), this.ccDragging.getCoordinates().getY(), this.ccDragging.getBlockType());
                CircuitComponentGraphics.MOVEMENT_FRAMES[this.ccDragging.getBlockType()].setAllowedToDraw(false);
                CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].setX((int)((float)(this.ccDragging.getCoordinates().getX() - this.actualGridHorizontalThreshold) * 40.0f) - CircuitComponentGraphics.FRAMES_BORDERS[this.ccDragging.getBlockType()]);
                CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].setY((int)((float)(this.ccDragging.getCoordinates().getY() - this.actualGridVerticalThreshold) * 22.5f) - CircuitComponentGraphics.FRAMES_BORDERS[this.ccDragging.getBlockType()]);
                CircuitComponentGraphics.COMPLETE_FRAMES[this.ccDragging.getBlockType()].setAllowedToDraw(true);
                this.ccDragging.setCanDraw(true);
                this.ccDragging = null;
            }
            int n10 = 0;
            for (Object e : this.cables) {
                ((CableLine)e).cableLineBuilding(this.actualGridHorizontalThreshold, this.actualGridVerticalThreshold);
                this.cablesGraphics.get(n10).cleanGraphics();
                ((CableLine)e).createGraphics(this.cablesGraphics.get(n10).getPictures());
                ++n10;
            }
            for (int i = 0; i < CircuitComponentGraphics.HIGHLIGHTS.length; ++i) {
                CircuitComponentGraphics.HIGHLIGHTS[i].setAllowedToDraw(false);
            }
        } else if (this.currentlySelected != null && this.currentlySelected instanceof INPUT && !((INPUT)this.currentlySelected).isToggle()) {
            ((INPUT)this.currentlySelected).setState(false);
        }
    }

    public void mouseWheelMoved(int n) {
        this.moveToolbarItems(n * 20 * -1);
    }

    public float getWindowXScale() {
        return this.windowXScale;
    }

    public float getWindowYScale() {
        return this.windowYScale;
    }

    public int rescaleTo1X(int n) {
        if (this.windowXScale > 1.0f) {
            return (int)((double)((float)n / this.windowXScale) + (double)((float)n / this.windowXScale) * (0.015 * (double)this.windowXScale));
        }
        if (this.windowXScale < 1.0f) {
            return (int)((double)((float)n / this.windowXScale) + (double)((float)n / this.windowXScale) * (0.015 / (double)this.windowXScale));
        }
        return (int)((float)n / this.windowXScale);
    }

    public int rescaleTo1Y(int n) {
        if (this.windowYScale > 1.0f) {
            return (int)((double)((float)n / this.windowYScale) + (double)((float)n / this.windowYScale) * (0.04 * (double)this.windowYScale));
        }
        if (this.windowYScale < 1.0f) {
            return (int)((double)((float)n / this.windowYScale) + (double)((float)n / this.windowYScale) * (0.06 / (double)this.windowYScale));
        }
        return (int)((float)n / this.windowYScale);
    }

    public Picture getGrid() {
        return GUIHandlerGraphics.GRID;
    }

    public boolean isGridFree(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n > 0) {
            --n;
        }
        if ((n5 = n + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getWidth()) < 127) {
            ++n5;
        }
        if (n2 > 0) {
            --n2;
        }
        if ((n4 = n2 + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getHeight()) < 127) {
            ++n4;
        }
        for (int i = n; i <= n5; ++i) {
            for (int j = n2; j <= n4; ++j) {
                if (!this.gridBusyPositions[i][j]) continue;
                return false;
            }
        }
        return true;
    }

    public void occupyGrid(int n, int n2, int n3) {
        for (int i = n; i < n + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getWidth(); ++i) {
            for (int j = n2; j < n2 + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getHeight(); ++j) {
                this.gridBusyPositions[i][j] = true;
            }
        }
    }

    public void freeGrid(int n, int n2, int n3) {
        for (int i = n; i < n + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getWidth(); ++i) {
            for (int j = n2; j < n2 + (int)CircuitComponentGraphics.BT_WIDTH_AND_HEIGHT[n3].getHeight(); ++j) {
                this.gridBusyPositions[i][j] = false;
            }
        }
    }

    public int getGridHorizontalThreshold() {
        return this.actualGridHorizontalThreshold;
    }

    public int getGridVerticalThreshold() {
        return this.actualGridVerticalThreshold;
    }

    public boolean[][] getGridBusyPositions() {
        return this.gridBusyPositions;
    }

    public DLListCC getPlacedComponents() {
        return this.placedComponents;
    }

    public ArrayListPicture getThingsToDraw() {
        return this.thingsToDraw;
    }

    public ArrayListCableLineGraphics getCablesGraphics() {
        return this.cablesGraphics;
    }

    public Mouse getMouse() {
        return this.mouse;
    }

    public void resizecatch() {
        int n;
        int n2;
        int n3 = n2 = this.getWidth();
        int n4 = n = this.getHeight();
        while (true) {
            if (n3 != n2 || n4 != n) {
                n2 = n3;
                n = n4;
                this.windowXScale = (float)n3 / (float)GUIHandlerGraphics.DEFAULT_DIMENSION.getWidth();
                this.windowYScale = (float)n4 / (float)GUIHandlerGraphics.DEFAULT_DIMENSION.getHeight();
                this.son.update(this.son.getGraphics());
            }
            n3 = this.getWidth();
            n4 = this.getHeight();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private int getBlockTypeFromPicture(Picture picture) {
        return picture.getPuppetOwner().getBlockType();
    }

    private CircuitComponent getInstanceFromPicture(Picture picture, int n, int n2) {
        return picture.getPuppetOwner().newInstance(n, n2);
    }
}

