/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;

public abstract class CircuitComponent
extends GraphicalObject {
    protected int nInputs;
    protected InputBridge[] inputs;
    protected int nOutputs;
    protected OutputBridge[] outputs;
    protected boolean canDraw;
    protected boolean visited;

    public CircuitComponent(int n, int n2, int n3, int n4, int n5, int n6) {
        super(new Coordinates(n3, n4), new Dimension(n5, n6));
        int n7;
        this.nInputs = n;
        this.inputs = new InputBridge[n];
        for (n7 = 0; n7 < n; ++n7) {
            this.inputs[n7] = new InputBridge(this, new Coordinates(0, 0), n7);
        }
        this.nOutputs = n2;
        this.outputs = new OutputBridge[n2];
        for (n7 = 0; n7 < n2; ++n7) {
            this.outputs[n7] = new OutputBridge(this, new Coordinates(0, 0), n7);
        }
        this.fixBridgesX(n3);
        this.fixBridgesY(n4);
        this.canDraw = true;
        this.visited = false;
    }

    public int getNInputs() {
        return this.nInputs;
    }

    public int getNOutputs() {
        return this.nOutputs;
    }

    public OutputBridge getOutputBridgeAt(int n) {
        return this.outputs[n];
    }

    public InputBridge getInputBridgeAt(int n) {
        return this.inputs[n];
    }

    public boolean getCanDraw() {
        return this.canDraw;
    }

    public void setCanDraw(boolean bl) {
        this.canDraw = bl;
    }

    public boolean getVisited() {
        return this.visited;
    }

    public void setVisited(boolean bl) {
        this.visited = bl;
    }

    @Override
    public void setX(int n) {
        this.getCoordinates().setX(n);
        this.fixBridgesX(n);
    }

    private void fixBridgesX(int n) {
        int n2;
        for (n2 = 0; n2 < this.nInputs; ++n2) {
            this.inputs[n2].setX((int)((float)n * 40.0f) + CircuitComponentGraphics.relativeInputBridgesCoordinates[this.getBlockType()][n2].getX());
        }
        for (n2 = 0; n2 < this.nOutputs; ++n2) {
            this.outputs[n2].setX((int)((float)n * 40.0f) + CircuitComponentGraphics.relativeOutputBridgesCoordinates[this.getBlockType()][n2].getX());
        }
    }

    @Override
    public void setY(int n) {
        this.getCoordinates().setY(n);
        this.fixBridgesY(n);
    }

    private void fixBridgesY(int n) {
        int n2;
        for (n2 = 0; n2 < this.nInputs; ++n2) {
            this.inputs[n2].setY((int)((float)n * 22.5f) + CircuitComponentGraphics.relativeInputBridgesCoordinates[this.getBlockType()][n2].getY());
        }
        for (n2 = 0; n2 < this.nOutputs; ++n2) {
            this.outputs[n2].setY((int)((float)n * 22.5f) + CircuitComponentGraphics.relativeOutputBridgesCoordinates[this.getBlockType()][n2].getY());
        }
    }

    public IOBridge checkTouched(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < this.nInputs; ++n3) {
            if (!this.inputs[n3].isOnYou(n, n2)) continue;
            return this.inputs[n3];
        }
        for (n3 = 0; n3 < this.nOutputs; ++n3) {
            if (!this.outputs[n3].isOnYou(n, n2)) continue;
            return this.outputs[n3];
        }
        return null;
    }

    public abstract void calculateOutputs();

    public abstract int getBlockType();

    public abstract Picture getPicture();

    public abstract CircuitComponent newInstance(int var1, int var2);

    public String toString() {
        this.calculateOutputs();
        return "";
    }
}

