/*
 * Decompiled with CFR 0.152.
 */
public class ArrayListPicture
implements Iterable {
    private static final int DEFAULT_CAPACITY = 8;
    private Picture[] pictures;
    private int size;
    private int capacity;

    public ArrayListPicture(int n) {
        this.capacity = n;
        this.size = 0;
        this.pictures = new Picture[n];
        for (int i = 0; i < n; ++i) {
            this.pictures[i] = null;
        }
    }

    public ArrayListPicture() {
        this(8);
    }

    private void expand() {
        int n;
        this.capacity *= 2;
        Picture[] pictureArray = new Picture[this.capacity];
        for (n = 0; n < this.size; ++n) {
            pictureArray[n] = this.pictures[n];
        }
        for (n = this.size; n < this.capacity; ++n) {
            pictureArray[n] = null;
        }
        this.pictures = pictureArray;
    }

    public void addAt(Picture picture, int n) {
        if (n > this.size) {
            return;
        }
        if (this.size == this.capacity) {
            this.expand();
        }
        for (int i = this.size; i > n; --i) {
            this.pictures[i] = this.pictures[i - 1];
        }
        this.pictures[n] = picture;
        ++this.size;
    }

    public void addLast(Picture picture) {
        if (this.size == this.capacity) {
            this.expand();
        }
        this.pictures[this.size] = picture;
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public Picture get(int n) {
        if (n >= this.size || n < 0) {
            return null;
        }
        return this.pictures[n];
    }

    public void remove(int n) {
        --this.size;
        for (int i = n; i < this.size; ++i) {
            this.pictures[i] = this.pictures[i + 1];
        }
        this.pictures[this.size] = null;
    }

    public void remove(Picture picture) {
        int n = this.search(picture);
        if (n != -1) {
            this.remove(n);
        }
    }

    public int search(Picture picture) {
        for (int i = 0; i < this.size; ++i) {
            if (this.pictures[i] != picture) continue;
            return i;
        }
        return -1;
    }

    public int searchByDescription(String string) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.pictures[i].getDescription().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int searchByDescriptionStartingFrom(String string, int n) {
        for (int i = n; i < this.size; ++i) {
            if (!this.pictures[i].getDescription().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void swap(int n, int n2) {
        if (n >= this.size || n < 0 || n2 >= this.size || n2 < 0) {
            return;
        }
        Picture picture = this.pictures[n];
        this.pictures[n] = this.pictures[n2];
        this.pictures[n2] = picture;
    }

    public ArrayListPictureIterator iterator() {
        return new ArrayListPictureIterator(this.pictures, this.size);
    }
}

