/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class ArrayListCoordinates
implements Iterable,
Serializable {
    private static final int DEFAULT_CAPACITY = 8;
    private Coordinates[] coordinates;
    private int size;
    private int capacity;

    public ArrayListCoordinates(int n) {
        this.capacity = n;
        this.size = 0;
        this.coordinates = new Coordinates[n];
        for (int i = 0; i < n; ++i) {
            this.coordinates[i] = null;
        }
    }

    public ArrayListCoordinates() {
        this(8);
    }

    private void expand() {
        int n;
        this.capacity *= 2;
        Coordinates[] coordinatesArray = new Coordinates[this.capacity];
        for (n = 0; n < this.size; ++n) {
            coordinatesArray[n] = this.coordinates[n];
        }
        for (n = this.size; n < this.capacity; ++n) {
            coordinatesArray[n] = null;
        }
        this.coordinates = coordinatesArray;
    }

    public void addAt(Coordinates coordinates, int n) {
        if (n > this.size) {
            return;
        }
        if (this.size == this.capacity) {
            this.expand();
        }
        for (int i = this.size; i > n; --i) {
            this.coordinates[i] = this.coordinates[i - 1];
        }
        this.coordinates[n] = coordinates;
        ++this.size;
    }

    public void addLast(Coordinates coordinates) {
        if (this.size == this.capacity) {
            this.expand();
        }
        this.coordinates[this.size] = coordinates;
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public Coordinates get(int n) {
        if (n >= this.size || n < 0) {
            return null;
        }
        return this.coordinates[n];
    }

    public void remove(int n) {
        --this.size;
        for (int i = n; i < this.size; ++i) {
            this.coordinates[i] = this.coordinates[i + 1];
        }
        this.coordinates[this.size] = null;
    }

    public void remove(Coordinates coordinates) {
        int n = this.search(coordinates);
        if (n != -1) {
            this.remove(n);
        }
    }

    public int search(Coordinates coordinates) {
        for (int i = 0; i < this.size; ++i) {
            if (this.coordinates[i] != coordinates) continue;
            return i;
        }
        return -1;
    }

    public ArrayListCoordinatesIterator iterator() {
        return new ArrayListCoordinatesIterator(this.coordinates, this.size);
    }
}

