/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class ArrayListCableLineGraphics
implements Iterable,
Serializable {
    private static final int DEFAULT_CAPACITY = 8;
    private CableLineGraphics[] cableLines;
    private int size;
    private int capacity;

    public ArrayListCableLineGraphics(int n) {
        this.capacity = n;
        this.size = 0;
        this.cableLines = new CableLineGraphics[n];
        for (int i = 0; i < n; ++i) {
            this.cableLines[i] = null;
        }
    }

    public ArrayListCableLineGraphics() {
        this(8);
    }

    private void expand() {
        int n;
        this.capacity *= 2;
        CableLineGraphics[] cableLineGraphicsArray = new CableLineGraphics[this.capacity];
        for (n = 0; n < this.size; ++n) {
            cableLineGraphicsArray[n] = this.cableLines[n];
        }
        for (n = this.size; n < this.capacity; ++n) {
            cableLineGraphicsArray[n] = null;
        }
        this.cableLines = cableLineGraphicsArray;
    }

    public void addAt(CableLineGraphics cableLineGraphics, int n) {
        if (n > this.size) {
            return;
        }
        if (this.size == this.capacity) {
            this.expand();
        }
        for (int i = this.size; i > n; --i) {
            this.cableLines[i] = this.cableLines[i - 1];
        }
        this.cableLines[n] = cableLineGraphics;
        ++this.size;
    }

    public void addLast(CableLineGraphics cableLineGraphics) {
        if (this.size == this.capacity) {
            this.expand();
        }
        this.cableLines[this.size] = cableLineGraphics;
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public CableLineGraphics get(int n) {
        if (n >= this.size || n < 0) {
            return null;
        }
        return this.cableLines[n];
    }

    public void remove(int n) {
        --this.size;
        for (int i = n; i < this.size; ++i) {
            this.cableLines[i] = this.cableLines[i + 1];
        }
        this.cableLines[this.size] = null;
    }

    public void remove(CableLineGraphics cableLineGraphics) {
        int n = this.search(cableLineGraphics);
        if (n != -1) {
            this.remove(n);
        }
    }

    public int search(CableLineGraphics cableLineGraphics) {
        for (int i = 0; i < this.size; ++i) {
            if (this.cableLines[i] != cableLineGraphics) continue;
            return i;
        }
        return -1;
    }

    public ArrayListCableLineGraphicsIterator iterator() {
        return new ArrayListCableLineGraphicsIterator(this.cableLines, this.size);
    }
}

