/*
 * Decompiled with CFR 0.152.
 */
import java.io.Serializable;

public class ArrayListCableLine
implements Iterable,
Serializable {
    private static final int DEFAULT_CAPACITY = 8;
    private CableLine[] cableLines;
    private int size;
    private int capacity;

    public ArrayListCableLine(int n) {
        this.capacity = n;
        this.size = 0;
        this.cableLines = new CableLine[n];
        for (int i = 0; i < n; ++i) {
            this.cableLines[i] = null;
        }
    }

    public ArrayListCableLine() {
        this(8);
    }

    private void expand() {
        int n;
        this.capacity *= 2;
        CableLine[] cableLineArray = new CableLine[this.capacity];
        for (n = 0; n < this.size; ++n) {
            cableLineArray[n] = this.cableLines[n];
        }
        for (n = this.size; n < this.capacity; ++n) {
            cableLineArray[n] = null;
        }
        this.cableLines = cableLineArray;
    }

    public void addAt(CableLine cableLine, int n) {
        if (n > this.size) {
            return;
        }
        if (this.size == this.capacity) {
            this.expand();
        }
        for (int i = this.size; i > n; --i) {
            this.cableLines[i] = this.cableLines[i - 1];
        }
        this.cableLines[n] = cableLine;
        ++this.size;
    }

    public void addLast(CableLine cableLine) {
        if (this.size == this.capacity) {
            this.expand();
        }
        this.cableLines[this.size] = cableLine;
        ++this.size;
    }

    public int getSize() {
        return this.size;
    }

    public CableLine get(int n) {
        if (n >= this.size || n < 0) {
            return null;
        }
        return this.cableLines[n];
    }

    public void remove(int n) {
        --this.size;
        for (int i = n; i < this.size; ++i) {
            this.cableLines[i] = this.cableLines[i + 1];
        }
        this.cableLines[this.size] = null;
    }

    public void remove(CableLine cableLine) {
        int n = this.search(cableLine);
        if (n != -1) {
            this.remove(n);
        }
    }

    public int search(CableLine cableLine) {
        for (int i = 0; i < this.size; ++i) {
            if (this.cableLines[i] != cableLine) continue;
            return i;
        }
        return -1;
    }

    public int searchByTerminal(IOBridge iOBridge) {
        for (int i = 0; i < this.size; ++i) {
            if (this.cableLines[i].getIBridge() != iOBridge && this.cableLines[i].getOBridge() != iOBridge) continue;
            return i;
        }
        return -1;
    }

    public ArrayListCableLineIterator iterator() {
        return new ArrayListCableLineIterator(this.cableLines, this.size);
    }
}

